import openmatrix as omx
import openpyxl
import numpy as np
import csv

#Apertura del file OMX di input
OMXfileI = omx.open_file('IMQ2013_zonecampionarie.omx')
print("File OMX di riferimento: ",OMXfileI.filename)
#Apertura del file OMX di output
OMXfileO = omx.open_file('IMQ2013_estrazione.omx','w')

#Caricamento delle informazioni sulla mappatura (per conversione cod. alfanumerico - cod. numerico)
excel_document = openpyxl.load_workbook('ZoneCampionarie2013.xlsx') 
nsheet = excel_document.sheetnames  
sheet = excel_document[nsheet[0]] 
zoneA = list()   
zoneN = np.zeros(209)
for j in range(0,209):
    zoneA.append(sheet.cell(row=j+2,column=2).value)
    zoneN[j] = sheet.cell(row=j+2,column=1).value    

#Apertura del file contenente il nuovo elenco delle zone
INfile = open('ESTRAZIONE.csv','r')
reader = csv.reader(INfile, delimiter=',')
NEWzone = list()
i=0
for row in reader:
    NEWzone.append(row[0])
    i=i+1
del NEWzone[0]
dim = len(NEWzone)

#Estrazione delle matrici
NEWmatrOD = np.zeros((dim,dim))
for pop in ['TO','PIE']:
    for mez in ['Pr','Pu']:
        for per in ['IG','OP']:
            for sco in ['sr','t']:
                if not (sco=='sr' and per=='OP'):
                    for i in range(0,dim):
                        for j in range(0,dim):
                            NEWmatrOD[i][j] = OMXfileI['Res'+pop+'m'+mez+per+sco][zoneA.index(NEWzone[i])][zoneA.index(NEWzone[j])]
                    OMXfileO['Res'+pop+'m'+mez+per+sco] = NEWmatrOD
                    #Scrittura dei metadati complementari
                    OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Indagine = 'IMQ 2013'
                    if pop=='TO':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Popolazione = 'Provincia di Torino'
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.NumCampione = 32460
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Popolazione = 'Regione Piemonte'
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.NumCampione = 52119
                    if mez=='Pr':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Modo = 'Privato'
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Modo = 'Pubblico'
                    if per=='IG':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Periodo = 'Intera giornata'
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Periodo = 'Ora di punta (arrivo 07:43-08:42)'
                    if sco=='sr':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Scopo = 'Tutti escluso ritorno'
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Scopo = 'Tutti'     

#Associazione della mappatura dell'indice
for i in range(0,dim):
    NEWzone[i] = zoneN[zoneA.index(NEWzone[i])]
OMXfileO.create_mapping('Mappatura',NEWzone)
print("FILE OMX CREATO: ",OMXfileO.filename)

#Chiusura dei file aperti
OMXfileI.close()
OMXfileO.close()
INfile.close()







